/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.util.Util;

public class PlayerSkinController {
    private static PlayerSkinController instance;
    public final Map<UUID, String> playerNames = new HashMap<UUID, String>();
    public final Map<UUID, Map<MinecraftProfileTexture.Type, ResourceLocation>> playerTextures = new HashMap<UUID, Map<MinecraftProfileTexture.Type, ResourceLocation>>();
    private String filePath;

    public static PlayerSkinController getInstance() {
        if (PlayerSkinController.newInstance()) {
            instance = new PlayerSkinController();
        }
        return instance;
    }

    private static boolean newInstance() {
        if (instance == null) {
            return true;
        }
        File file = CustomNpcs.Dir;
        return file != null && !PlayerSkinController.instance.filePath.equals(file.getName());
    }

    public PlayerSkinController() {
        instance = this;
        this.filePath = CustomNpcs.getWorldSaveDirectory().getAbsolutePath();
        this.loadPlayerSkins();
    }

    public String get(EntityPlayerMP player, int type) {
        if (type < 0) {
            type *= -1;
        }
        Map<MinecraftProfileTexture.Type, ResourceLocation> data = this.getData(player.func_110124_au());
        ResourceLocation loc = null;
        if (data != null) {
            loc = data.get(MinecraftProfileTexture.Type.values()[type % MinecraftProfileTexture.Type.values().length]);
        }
        return loc == null ? null : loc.toString();
    }

    @Nullable
    public Map<MinecraftProfileTexture.Type, ResourceLocation> getData(UUID uuid) {
        if (uuid == null || !this.playerTextures.containsKey(uuid)) {
            return null;
        }
        return this.playerTextures.get(uuid);
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList listUUIDs = new NBTTagList();
        for (UUID uuid : this.playerTextures.keySet()) {
            if (uuid == null) continue;
            NBTTagCompound nbtPlayer = new NBTTagCompound();
            nbtPlayer.func_186854_a("UUID", uuid);
            NBTTagList listTxrs = new NBTTagList();
            for (MinecraftProfileTexture.Type epst : this.playerTextures.get(uuid).keySet()) {
                ResourceLocation loc = this.playerTextures.get(uuid).get(epst);
                if (loc == null) continue;
                NBTTagCompound nbtSkin = new NBTTagCompound();
                nbtSkin.func_74778_a("Type", epst.name());
                nbtSkin.func_74778_a("Location", loc.toString());
                listTxrs.func_74742_a((NBTBase)nbtSkin);
            }
            nbtPlayer.func_74782_a("Textures", (NBTBase)listTxrs);
            nbtPlayer.func_74778_a("Player", this.playerNames.get(uuid) == null ? "null" : this.playerNames.get(uuid));
            listUUIDs.func_74742_a((NBTBase)nbtPlayer);
        }
        compound.func_74782_a("Data", (NBTBase)listUUIDs);
        return compound;
    }

    public NBTTagCompound getNBT(UUID uuid) {
        NBTTagCompound nbtPlayer = new NBTTagCompound();
        nbtPlayer.func_186854_a("UUID", uuid);
        NBTTagList listTxrs = new NBTTagList();
        for (MinecraftProfileTexture.Type epst : this.playerTextures.get(uuid).keySet()) {
            ResourceLocation loc = this.playerTextures.get(uuid).get(epst);
            if (loc == null) continue;
            NBTTagCompound nbtSkin = new NBTTagCompound();
            nbtSkin.func_74778_a("Type", epst.name());
            nbtSkin.func_74778_a("Location", loc.toString());
            listTxrs.func_74742_a((NBTBase)nbtSkin);
        }
        nbtPlayer.func_74782_a("Textures", (NBTBase)listTxrs);
        nbtPlayer.func_74778_a("Player", this.playerNames.get(uuid) == null ? "null" : this.playerNames.get(uuid));
        return nbtPlayer;
    }

    public UUID loadPlayerSkin(NBTTagCompound nbtSkin) {
        if (nbtSkin == null) {
            return null;
        }
        UUID uuid = nbtSkin.func_186857_a("UUID");
        this.playerNames.put(uuid, nbtSkin.func_74779_i("Player"));
        if (!this.playerTextures.containsKey(uuid)) {
            this.playerTextures.put(uuid, new EnumMap(MinecraftProfileTexture.Type.class));
        }
        Map<MinecraftProfileTexture.Type, ResourceLocation> skins = this.playerTextures.get(uuid);
        for (int i = 0; i < nbtSkin.func_150295_c("Textures", 10).func_74745_c(); ++i) {
            MinecraftProfileTexture.Type type;
            NBTTagCompound nbt = nbtSkin.func_150295_c("Textures", 10).func_150305_b(i);
            switch (nbt.func_74779_i("Type").toLowerCase()) {
                case "cape": {
                    type = MinecraftProfileTexture.Type.CAPE;
                    break;
                }
                case "elytra": {
                    type = MinecraftProfileTexture.Type.ELYTRA;
                    break;
                }
                default: {
                    type = MinecraftProfileTexture.Type.SKIN;
                }
            }
            skins.put(type, new ResourceLocation(Util.instance.deleteColor(nbt.func_74779_i("Location"))));
        }
        this.playerTextures.put(uuid, skins);
        return uuid;
    }

    private void loadPlayerSkins() {
        CustomNpcs.debugData.start(null);
        File saveDir = CustomNpcs.Dir;
        if (saveDir == null) {
            CustomNpcs.debugData.end(null);
            return;
        }
        this.filePath = saveDir.getName();
        try {
            File file = new File(saveDir, "player_skins.dat");
            if (file.exists()) {
                this.loadPlayerSkins(file);
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }

    private void loadPlayerSkins(File file) {
        try {
            this.loadPlayerSkins(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0])));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void loadPlayerSkins(NBTTagCompound compound) {
        this.playerNames.clear();
        this.playerTextures.clear();
        if (compound.func_150297_b("Data", 9)) {
            for (int i = 0; i < compound.func_150295_c("Data", 10).func_74745_c(); ++i) {
                this.loadPlayerSkin(compound.func_150295_c("Data", 10).func_150305_b(i));
            }
        }
    }

    public void logged(EntityPlayerMP player) {
        UUID uuid = player.func_110124_au();
        if (this.playerTextures.containsKey(uuid)) {
            this.playerNames.put(uuid, player.func_70005_c_());
            this.sendToAll(player);
        } else {
            Server.sendData(player, EnumPacketClient.PLAYER_SKIN_GET, new Object[0]);
        }
        for (EntityPlayerMP pl : Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_181057_v()) {
            if (pl.equals((Object)player) || !this.playerTextures.containsKey(pl.func_110124_au())) continue;
            Server.sendData(player, EnumPacketClient.PLAYER_SKIN_ADD, this.getNBT(pl.func_110124_au()));
        }
    }

    public void save() {
        CustomNpcs.debugData.start(null);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(new File(CustomNpcs.Dir, "player_skins.dat").toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }

    public void sendToAll(EntityPlayerMP player) {
        UUID uuid = player.func_110124_au();
        if (!this.playerTextures.containsKey(uuid)) {
            return;
        }
        this.playerNames.put(uuid, player.func_70005_c_());
        NBTTagCompound nbtPlayer = this.getNBT(uuid);
        for (EntityPlayerMP pl : Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_181057_v()) {
            Server.sendData(pl, EnumPacketClient.PLAYER_SKIN_ADD, nbtPlayer);
        }
    }

    public void set(EntityPlayerMP player, boolean isSmallArms, int body, int bodyColor, int hair, int hairColor, int face, int eyesColor, int leg, int jacket, int shoes, int ... peculiarities) {
        UUID uuid = player.func_110124_au();
        if (!this.playerTextures.containsKey(uuid)) {
            this.playerTextures.put(uuid, new EnumMap(MinecraftProfileTexture.Type.class));
        }
        Map<MinecraftProfileTexture.Type, ResourceLocation> data = this.getData(player.func_110124_au());
        StringBuilder path = new StringBuilder("textures/entity/custom/" + (isSmallArms ? "female" : "male") + "_" + body + "_" + bodyColor + "_" + hair + "_" + hairColor + "_" + face + "_" + eyesColor + "_" + leg + "_" + jacket + "_" + shoes);
        for (int id : peculiarities) {
            path.append("_").append(id);
        }
        path.append(".png");
        if (data != null) {
            data.put(MinecraftProfileTexture.Type.SKIN, new ResourceLocation("customnpcs", Util.instance.deleteColor(path.toString())));
            this.playerTextures.put(uuid, data);
            this.sendToAll(player);
        }
    }

    public void set(EntityPlayerMP player, String location, int type) {
        Map<MinecraftProfileTexture.Type, ResourceLocation> data;
        UUID uuid = player.func_110124_au();
        if (type < 0) {
            type *= -1;
        }
        MinecraftProfileTexture.Type t = MinecraftProfileTexture.Type.values()[type % MinecraftProfileTexture.Type.values().length];
        if (!this.playerTextures.containsKey(uuid)) {
            this.playerTextures.put(uuid, new EnumMap(MinecraftProfileTexture.Type.class));
            this.playerTextures.get(uuid).put(MinecraftProfileTexture.Type.SKIN, new ResourceLocation("minecraft", (uuid.hashCode() & 1) == 1 ? "textures/entity/alex.png" : "textures/entity/steve.png"));
        }
        if ((data = this.getData(player.func_110124_au())) != null) {
            if (location == null || location.isEmpty()) {
                data.remove(t);
            } else {
                data.put(t, new ResourceLocation(Util.instance.deleteColor(location)));
            }
            this.playerTextures.put(uuid, data);
            this.sendToAll(player);
        }
    }

    public boolean hasData(UUID uuid) {
        return this.playerTextures.containsKey(uuid);
    }
}

